
#ifndef MW_ATP_UTIL_SEP_H
#define MW_ATP_UTIL_SEP_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 07 12:27:43 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_sep.h#1:incl:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
/******** Public Variables ********/
/******** Public Functions ********/

/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_LoadCode 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_resAdd - resident address
 *  DxUint32_t  TST_cacheAddr - cache address
 *
 * Outputs:
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the resident and cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_LoadCode(DxUint32_t TST_resAdd, DxUint32_t TST_cacheAddr);

/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_LoadExtCode 		
 * 
 * Inputs:
 * 	
 *
 * Outputs:
 *  DxUint32_t*  TST_extCacheAddr - allocated ext cache  address
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the external(3rd party) cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_LoadExtCode(DxUint32_t TST_extCacheAddr);


/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_OSLoadCode 		
 * 
 * Inputs:
 * 	
 *
 * Outputs:
 *  DxUint32_t*  TST_resAdd_ptr - allocated resident address
 *  DxUint32_t*  TST_cacheAddr - allocated cache address
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the resident and cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_OSLoadCode(DxUint32_t* TST_resAdd_ptr, DxUint32_t* TST_cacheAddr_ptr);


/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_OSLoadExtCode 		
 * 
 * Inputs:
 * 	
 *
 * Outputs:
 *  DxUint32_t*  TST_extCacheAddr - allocated ext cache  address
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the external(3rd party) cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_OSLoadExtCode(DxUint32_t TST_extCacheAddr);

/********************************************************************************
 * Function Name:                                                           
 * 	MW_TST_DX_CC_INIT 		
 * 
 * Inputs:
 *
 * Outputs:
 * 	DxError_t - Function error return		    					  		
 *
 * Description:																	
 * This function calls the correct DX_CC_Init() 
 * 
 ********************************************************************************/
DxError_t MW_TST_DX_CC_INIT(void);

#ifdef __cplusplus
}
#endif

#endif /*MW_ATP_UTIL_SEP_H*/

